/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys;

import java.util.List;
import org.apache.jena.graph.Graph;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerException;
import org.apache.jena.reasoner.ReasonerFactory;
import org.apache.jena.reasoner.rulesys.FBRuleInfGraph;
import org.apache.jena.reasoner.rulesys.GenericRuleReasoner;
import org.apache.jena.reasoner.rulesys.Rule;

public class OWLMicroReasoner
extends GenericRuleReasoner
implements Reasoner {
    protected static final String MICRO_RULE_FILE = "etc/owl-fb-micro.rules";
    protected static List<Rule> microRuleSet;

    public static List<Rule> loadRules() {
        if (microRuleSet == null) {
            microRuleSet = OWLMicroReasoner.loadRules(MICRO_RULE_FILE);
        }
        return microRuleSet;
    }

    public OWLMicroReasoner(ReasonerFactory factory) {
        super(OWLMicroReasoner.loadRules(), factory);
        this.setOWLTranslation(true);
        this.setMode(HYBRID);
        this.setTransitiveClosureCaching(true);
    }

    @Override
    public InfGraph bind(Graph data) throws ReasonerException {
        InfGraph graph = super.bind(data);
        ((FBRuleInfGraph)graph).setDatatypeRangeValidation(true);
        return graph;
    }
}

