/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rfc3986;

import org.apache.jena.rfc3986.LibParseIRI;

public enum URIScheme {
    GENERAL("RFC3986"),
    HTTP("http"),
    HTTPS("https"),
    URN("urn"),
    URN_UUID("urn", "uuid"),
    UUID("uuid"),
    FILE("file"),
    DID("did"),
    URN_OID("urn", "oid"),
    URN_EXAMPLE("urn", "example"),
    OID("oid"),
    EXAMPLE("example");

    private final String name;
    private final String schemeName;
    private final String schemeNameColon;
    private final String urnNamespace;
    private final String prefix;

    public static URIScheme get(String name) {
        if (name == null) {
            return null;
        }
        if (name.endsWith(":")) {
            name = name.substring(0, name.length() - 1);
        }
        for (URIScheme scheme : URIScheme.values()) {
            if (!scheme.getName().equalsIgnoreCase(name)) continue;
            return scheme;
        }
        return null;
    }

    private URIScheme(String schemeName) {
        this.name = schemeName;
        this.schemeNameColon = schemeName + ":";
        this.schemeName = schemeName;
        this.urnNamespace = null;
        this.prefix = this.name + ":";
    }

    private URIScheme(String schemeName, String urnNS) {
        this.name = schemeName + ":" + urnNS;
        this.schemeName = schemeName;
        this.schemeNameColon = schemeName + ":";
        this.urnNamespace = urnNS;
        this.prefix = schemeName + ":" + urnNS + ":";
    }

    public static boolean matchesExact(String iriStr, URIScheme scheme) {
        return iriStr.startsWith(scheme.schemeNameColon);
    }

    public static boolean matchesIgnoreCase(String iriStr, URIScheme scheme) {
        return LibParseIRI.caseInsensitivePrefix(iriStr, scheme.schemeNameColon);
    }

    public static boolean fromScheme(String iriStr, URIScheme scheme) {
        return LibParseIRI.caseInsensitivePrefix(iriStr, scheme.prefix);
    }

    public final boolean isURN() {
        return switch (this.ordinal()) {
            case 3, 4, 8, 9 -> true;
            default -> false;
        };
    }

    public String getSchemeName() {
        return this.schemeName;
    }

    public String getURNNamespace() {
        return this.urnNamespace;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

