/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.internal.shared.FeatureExpression;
import org.apache.sis.feature.internal.shared.FeatureProjectionBuilder;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.base.BinaryFunctionWidening;
import org.apache.sis.math.Fraction;
import org.apache.sis.math.NumberType;
import org.opengis.util.ScopedName;

public abstract class ArithmeticFunction<R>
extends BinaryFunctionWidening<R, Number, Number>
implements FeatureExpression<R, Number>,
Optimization.OnExpression<R, Number> {
    private static final long serialVersionUID = 2818625862630588268L;

    protected ArithmeticFunction(Expression<R, ? extends Number> expression1, Expression<R, ? extends Number> expression2) {
        super(expression1, expression2);
    }

    @Override
    public Class<? extends Number> getResultClass() {
        NumberType type = this.widestOperandType();
        switch (type) {
            case BYTE: 
            case SHORT: 
            case INTEGER: {
                return Long.class;
            }
            case LONG: {
                break;
            }
            default: {
                type = ArithmeticFunction.effective(type);
                if (!type.isReal()) break;
                return type.classOfValues(false).asSubclass(Number.class);
            }
        }
        return Number.class;
    }

    private static DefaultAttributeType<Number> createNumericType(ScopedName name) {
        return ArithmeticFunction.createType(Number.class, name);
    }

    protected abstract DefaultAttributeType<Number> expectedType();

    @Override
    public final FeatureProjectionBuilder.Item expectedType(FeatureProjectionBuilder addTo) {
        return addTo.addSourceProperty(this.expectedType(), false);
    }

    @Override
    public final Expression<R, ? extends Number> optimize(Optimization optimization) {
        Expression optimized;
        Expression result = Optimization.OnExpression.super.optimize(optimization);
        if (result instanceof ArithmeticFunction && (optimized = ((ArithmeticFunction)result).specialize()) != null) {
            return optimized;
        }
        return result;
    }

    @Override
    public final Number apply(R feature) {
        Number right;
        Number left = (Number)this.expression1.apply(feature);
        if (left != null && (right = (Number)this.expression2.apply(feature)) != null) {
            return this.apply(left, right);
        }
        return null;
    }

    public static final class Divide<R>
    extends ArithmeticFunction<R> {
        private static final long serialVersionUID = -7709291845568648891L;
        private static final ScopedName NAME = Divide.createName("Divide");
        private static final DefaultAttributeType<Number> TYPE = ArithmeticFunction.createNumericType(NAME);

        public Divide(Expression<R, ? extends Number> expression1, Expression<R, ? extends Number> expression2) {
            super(expression1, expression2);
        }

        @Override
        public Expression<R, Number> recreate(Expression<R, ?>[] effective) {
            return new Divide<R>(effective[0].toValueType(Number.class), effective[1].toValueType(Number.class));
        }

        @Override
        protected DefaultAttributeType<Number> expectedType() {
            return TYPE;
        }

        @Override
        public ScopedName getFunctionName() {
            return NAME;
        }

        @Override
        protected char symbol() {
            return '\u00f7';
        }

        @Override
        protected Number applyAsDouble(double left, double right) {
            return left / right;
        }

        @Override
        protected Number applyAsFraction(Fraction left, Fraction right) {
            return left.divide(right);
        }

        @Override
        protected Number applyAsDecimal(BigDecimal left, BigDecimal right) {
            return left.divide(right);
        }

        @Override
        protected Number applyAsInteger(BigInteger left, BigInteger right) {
            BigInteger[] r = left.divideAndRemainder(right);
            if (BigInteger.ZERO.equals(r[1])) {
                return r[0];
            }
            return Fraction.valueOf((long)r[1].longValueExact(), (long)right.longValueExact()).add(new Fraction(r[0].intValueExact(), 1));
        }

        @Override
        protected Number applyAsLong(long left, long right) {
            long r = left / right;
            if (left % right == 0L) {
                return r;
            }
            return Fraction.valueOf((long)left, (long)right);
        }

        @Override
        public Class<? extends Number> getResultClass() {
            return Divide.effective(this.widestOperandType()) == NumberType.DOUBLE ? Double.class : Number.class;
        }
    }

    public static final class Multiply<R>
    extends ArithmeticFunction<R> {
        private static final long serialVersionUID = -1300022614832645625L;
        private static final ScopedName NAME = Multiply.createName("Multiply");
        private static final DefaultAttributeType<Number> TYPE = ArithmeticFunction.createNumericType(NAME);

        public Multiply(Expression<R, ? extends Number> expression1, Expression<R, ? extends Number> expression2) {
            super(expression1, expression2);
        }

        @Override
        public Expression<R, Number> recreate(Expression<R, ?>[] effective) {
            return new Multiply<R>(effective[0].toValueType(Number.class), effective[1].toValueType(Number.class));
        }

        @Override
        protected DefaultAttributeType<Number> expectedType() {
            return TYPE;
        }

        @Override
        public ScopedName getFunctionName() {
            return NAME;
        }

        @Override
        protected char symbol() {
            return '\u00d7';
        }

        @Override
        protected Number applyAsDouble(double left, double right) {
            return left * right;
        }

        @Override
        protected Number applyAsFraction(Fraction left, Fraction right) {
            return left.multiply(right);
        }

        @Override
        protected Number applyAsDecimal(BigDecimal left, BigDecimal right) {
            return left.multiply(right);
        }

        @Override
        protected Number applyAsInteger(BigInteger left, BigInteger right) {
            return left.multiply(right);
        }

        @Override
        protected Number applyAsLong(long left, long right) {
            return Math.multiplyExact(left, right);
        }
    }

    public static final class Subtract<R>
    extends ArithmeticFunction<R> {
        private static final long serialVersionUID = 3048878022726271508L;
        private static final ScopedName NAME = Subtract.createName("Subtract");
        private static final DefaultAttributeType<Number> TYPE = ArithmeticFunction.createNumericType(NAME);

        public Subtract(Expression<R, ? extends Number> expression1, Expression<R, ? extends Number> expression2) {
            super(expression1, expression2);
        }

        @Override
        public Expression<R, Number> recreate(Expression<R, ?>[] effective) {
            return new Subtract<R>(effective[0].toValueType(Number.class), effective[1].toValueType(Number.class));
        }

        @Override
        protected DefaultAttributeType<Number> expectedType() {
            return TYPE;
        }

        @Override
        public ScopedName getFunctionName() {
            return NAME;
        }

        @Override
        protected char symbol() {
            return '\u2212';
        }

        @Override
        protected Number applyAsDouble(double left, double right) {
            return left - right;
        }

        @Override
        protected Number applyAsFraction(Fraction left, Fraction right) {
            return left.subtract(right);
        }

        @Override
        protected Number applyAsDecimal(BigDecimal left, BigDecimal right) {
            return left.subtract(right);
        }

        @Override
        protected Number applyAsInteger(BigInteger left, BigInteger right) {
            return left.subtract(right);
        }

        @Override
        protected Number applyAsLong(long left, long right) {
            return Math.subtractExact(left, right);
        }
    }

    public static final class Add<R>
    extends ArithmeticFunction<R> {
        private static final long serialVersionUID = 5445433312445869201L;
        private static final ScopedName NAME = Add.createName("Add");
        private static final DefaultAttributeType<Number> TYPE = ArithmeticFunction.createNumericType(NAME);

        public Add(Expression<R, ? extends Number> expression1, Expression<R, ? extends Number> expression2) {
            super(expression1, expression2);
        }

        @Override
        public Expression<R, Number> recreate(Expression<R, ?>[] effective) {
            return new Add<R>(effective[0].toValueType(Number.class), effective[1].toValueType(Number.class));
        }

        @Override
        protected DefaultAttributeType<Number> expectedType() {
            return TYPE;
        }

        @Override
        public ScopedName getFunctionName() {
            return NAME;
        }

        @Override
        protected char symbol() {
            return '+';
        }

        @Override
        protected Number applyAsDouble(double left, double right) {
            return left + right;
        }

        @Override
        protected Number applyAsFraction(Fraction left, Fraction right) {
            return left.add(right);
        }

        @Override
        protected Number applyAsDecimal(BigDecimal left, BigDecimal right) {
            return left.add(right);
        }

        @Override
        protected Number applyAsInteger(BigInteger left, BigInteger right) {
            return left.add(right);
        }

        @Override
        protected Number applyAsLong(long left, long right) {
            return Math.addExact(left, right);
        }
    }
}

