/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.util.Objects;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.math.NumberType;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.internal.shared.Numerics;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;

public class NumberRange<E extends Number>
extends Range<E> {
    private static final long serialVersionUID = -3198281191274903617L;
    private static final WeakHashSet<NumberRange<?>> POOL = new WeakHashSet<NumberRange>(NumberRange.class);

    static <E extends Number, T extends NumberRange<E>> T unique(T range) {
        if (!range.isEmpty()) {
            range = POOL.unique(range);
        }
        return range;
    }

    static boolean isCacheable(Number n) {
        if (n == null) {
            return true;
        }
        if (n instanceof Double) {
            double value = (Double)n;
            return !Double.isNaN(value) || Double.doubleToRawLongBits(value) == 9221120237041090560L;
        }
        if (n instanceof Float) {
            float value = ((Float)n).floatValue();
            return !Float.isNaN(value) || Float.floatToRawIntBits(value) == 2143289344;
        }
        return NumberType.isReal(n.getClass());
    }

    public static <N extends Number> NumberRange<N> create(Class<N> type, N value) {
        NumberRange<N> range = new NumberRange<N>(type, value, true, value, true);
        if (NumberRange.isCacheable(value)) {
            range = NumberRange.unique(range);
        }
        return range;
    }

    public static NumberRange<Byte> create(byte minValue, boolean isMinIncluded, byte maxValue, boolean isMaxIncluded) {
        return NumberRange.unique(new NumberRange<Byte>(Byte.class, minValue, isMinIncluded, maxValue, isMaxIncluded));
    }

    public static NumberRange<Short> create(short minValue, boolean isMinIncluded, short maxValue, boolean isMaxIncluded) {
        Short min = minValue;
        Short max = minValue == maxValue ? min : maxValue;
        return NumberRange.unique(new NumberRange<Short>(Short.class, min, isMinIncluded, max, isMaxIncluded));
    }

    public static NumberRange<Integer> create(int minValue, boolean isMinIncluded, int maxValue, boolean isMaxIncluded) {
        Integer min = minValue;
        Integer max = minValue == maxValue ? min : maxValue;
        return NumberRange.unique(new NumberRange<Integer>(Integer.class, min, isMinIncluded, max, isMaxIncluded));
    }

    public static NumberRange<Long> create(long minValue, boolean isMinIncluded, long maxValue, boolean isMaxIncluded) {
        Long min = minValue;
        Long max = minValue == maxValue ? min : maxValue;
        return NumberRange.unique(new NumberRange<Long>(Long.class, min, isMinIncluded, max, isMaxIncluded));
    }

    public static NumberRange<Float> create(float minValue, boolean isMinIncluded, float maxValue, boolean isMaxIncluded) {
        Float max;
        Float min;
        return NumberRange.unique(new NumberRange<Float>(Float.class, min, isMinIncluded, Objects.equals(min = NumberRange.valueOf("minValue", minValue, Float.NEGATIVE_INFINITY), max = NumberRange.valueOf("maxValue", maxValue, Float.POSITIVE_INFINITY)) ? min : max, isMaxIncluded));
    }

    static Float valueOf(String name, float value, float infinity) {
        if (Float.isNaN(value)) {
            throw new IllegalArgumentException(Errors.format((short)137, name));
        }
        return value != infinity ? Float.valueOf(value) : null;
    }

    public static NumberRange<Double> create(double minValue, boolean isMinIncluded, double maxValue, boolean isMaxIncluded) {
        Double max;
        Double min;
        return NumberRange.unique(new NumberRange<Double>(Double.class, min, isMinIncluded, Objects.equals(min = NumberRange.valueOf("minValue", minValue, Double.NEGATIVE_INFINITY), max = NumberRange.valueOf("maxValue", maxValue, Double.POSITIVE_INFINITY)) ? min : max, isMaxIncluded));
    }

    static Double valueOf(String name, double value, double infinity) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException(Errors.format((short)137, name));
        }
        return value != infinity ? Double.valueOf(value) : null;
    }

    public static NumberRange<?> createBestFit(Number minValue, boolean isMinIncluded, Number maxValue, boolean isMaxIncluded) {
        return NumberRange.createBestFit(false, minValue, isMinIncluded, maxValue, isMaxIncluded);
    }

    public static NumberRange<?> createBestFit(boolean asFloat, Number minValue, boolean isMinIncluded, Number maxValue, boolean isMaxIncluded) {
        boolean isCacheable;
        NumberType type;
        if (asFloat) {
            if (minValue == null && maxValue == null) {
                return null;
            }
            type = NumberRange.isFloat(minValue) && NumberRange.isFloat(maxValue) ? NumberType.FLOAT : NumberType.DOUBLE;
        } else {
            type = NumberRange.bestFit(minValue, maxValue);
            if (type == NumberType.NULL) {
                return null;
            }
        }
        Number min = type.cast(minValue);
        Number max = type.cast(maxValue);
        boolean bl = isCacheable = NumberRange.isCacheable(min) && NumberRange.isCacheable(max);
        if (isCacheable && Objects.equals(min, max)) {
            max = min;
        }
        NumberRange<Number> range = new NumberRange<Number>(type.classOfValues(false), min, isMinIncluded, max, isMaxIncluded);
        if (isCacheable) {
            range = NumberRange.unique(range);
        }
        return range;
    }

    static NumberType bestFit(Number minValue, Number maxValue) {
        return NumberType.forNumberClasses(Numbers.narrowestClass(minValue), Numbers.narrowestClass(maxValue));
    }

    private static boolean isFloat(Number value) {
        return value == null || Double.doubleToRawLongBits(value.floatValue()) == Double.doubleToRawLongBits(value.doubleValue());
    }

    public static NumberRange<Integer> createLeftBounded(int minValue, boolean isMinIncluded) {
        return POOL.unique(new NumberRange<Object>((Class<Object>)Integer.class, minValue, isMinIncluded, null, false));
    }

    public static <N extends Number> NumberRange<N> castOrCopy(Range<N> range) {
        if (range instanceof NumberRange) {
            return (NumberRange)range;
        }
        return new NumberRange<N>(range);
    }

    public NumberRange(Range<E> range) {
        super(range);
    }

    public NumberRange(Class<E> type, ValueRange range) throws IllegalArgumentException {
        super(type, Numbers.cast(NumberRange.valueOf("minimum", range.minimum(), Double.NEGATIVE_INFINITY), type), range.isMinIncluded(), Numbers.cast(NumberRange.valueOf("maximum", range.maximum(), Double.POSITIVE_INFINITY), type), range.isMaxIncluded());
    }

    public NumberRange(Class<E> type, E minValue, boolean isMinIncluded, E maxValue, boolean isMaxIncluded) {
        super(type, minValue, isMinIncluded, maxValue, isMaxIncluded);
    }

    NumberRange(Class<E> type, Range<? extends Number> range) throws IllegalArgumentException {
        super(type, Numbers.cast((Number)range.minValue, type), range.isMinIncluded, Numbers.cast((Number)range.maxValue, type), range.isMaxIncluded);
    }

    @Override
    Range<E> create(E minValue, boolean isMinIncluded, E maxValue, boolean isMaxIncluded) {
        return new NumberRange<E>(this.elementType, minValue, isMinIncluded, maxValue, isMaxIncluded);
    }

    <N extends Number> NumberRange<N> convertAndCast(NumberRange<?> range, Class<N> type) throws IllegalArgumentException {
        if (range.elementType == type) {
            return range;
        }
        return new NumberRange<N>(type, range);
    }

    public <N extends Number> NumberRange<N> castTo(Class<N> type) throws IllegalArgumentException {
        if (this.elementType == type) {
            return this;
        }
        return new NumberRange<N>(type, this);
    }

    @Override
    Range<E>[] newArray(int length) {
        return new NumberRange[length];
    }

    public double getMinDouble() {
        Number value = (Number)this.getMinValue();
        return value != null ? value.doubleValue() : Double.NEGATIVE_INFINITY;
    }

    public double getMinDouble(boolean inclusive) {
        double value = this.getMinDouble();
        if (inclusive != this.isMinIncluded()) {
            value = NumberRange.next(this.getElementType(), value, inclusive);
        }
        return value;
    }

    public double getMaxDouble() {
        Number value = (Number)this.getMaxValue();
        return value != null ? value.doubleValue() : Double.POSITIVE_INFINITY;
    }

    public double getMaxDouble(boolean inclusive) {
        double value = this.getMaxDouble();
        if (inclusive != this.isMaxIncluded()) {
            value = NumberRange.next(this.getElementType(), value, !inclusive);
        }
        return value;
    }

    public double getMedian() {
        return this.medianOrSpan(true);
    }

    public double getSpan() {
        return this.medianOrSpan(false);
    }

    private double medianOrSpan(boolean median) {
        if (this.minValue == null) {
            if (median) {
                return this.maxValue == null ? Double.NaN : Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        if (this.maxValue == null) {
            return Double.POSITIVE_INFINITY;
        }
        if (NumberType.isInteger(this.getElementType())) {
            long min = ((Number)((Object)this.minValue)).longValue();
            long max = ((Number)((Object)this.maxValue)).longValue();
            if (!this.isMinIncluded) {
                ++min;
            }
            if (!this.isMaxIncluded) {
                --max;
            }
            if (min <= max) {
                return median ? MathFunctions.average(min, max) : Numerics.toUnsignedDouble(max - min);
            }
        } else {
            double max;
            double min = ((Number)((Object)this.minValue)).doubleValue();
            if (min <= (max = ((Number)((Object)this.maxValue)).doubleValue())) {
                return median ? (min + max) * 0.5 : max - min;
            }
            if (Double.isNaN(min) && (this.isMinIncluded || !Double.isNaN(max))) {
                return min;
            }
            if (Double.isNaN(max)) {
                return max;
            }
        }
        return median ? Double.NaN : 0.0;
    }

    private static double next(Class<?> type, double value, boolean up) {
        if (NumberType.isInteger(type)) {
            value = up ? (value += 1.0) : (value -= 1.0);
        } else if (type == Float.class) {
            float fv = (float)value;
            value = up ? (double)Math.nextUp(fv) : (double)Math.nextDown(fv);
        } else if (type == Double.class) {
            value = up ? Math.nextUp(value) : Math.nextDown(value);
        } else {
            throw new IllegalStateException(Errors.format((short)138, type));
        }
        return value;
    }

    public boolean containsAny(Number value) throws IllegalArgumentException {
        int c;
        if (value == null) {
            return false;
        }
        NumberType type = NumberType.forNumberClasses(this.elementType, value.getClass());
        try {
            value = type.cast(value);
        }
        catch (UnsupportedOperationException e) {
            throw new IllegalArgumentException(Errors.format((short)12, value, (Object)type), e);
        }
        if (this.minValue != null) {
            c = ((Comparable)((Object)type.cast((Number)((Object)this.minValue)))).compareTo(value);
            if (this.isMinIncluded ? c > 0 : c >= 0) {
                return false;
            }
        }
        if (this.maxValue != null) {
            c = ((Comparable)((Object)type.cast((Number)((Object)this.maxValue)))).compareTo(value);
            if (this.isMaxIncluded ? c < 0 : c <= 0) {
                return false;
            }
        }
        return true;
    }

    public boolean containsAny(NumberRange<?> range) throws IllegalArgumentException {
        Class<? extends Number> type = Numbers.widestClass(this.elementType, range.elementType);
        return this.castTo(type).contains(this.convertAndCast(range, type));
    }

    public boolean intersectsAny(NumberRange<?> range) throws IllegalArgumentException {
        Class<? extends Number> type = Numbers.widestClass(this.elementType, range.elementType);
        return this.castTo(type).intersects(this.convertAndCast(range, type));
    }

    public NumberRange<?> intersectAny(NumberRange<?> range) throws IllegalArgumentException {
        Class<? extends Number> type = Numbers.widestClass(this.elementType, range.elementType);
        NumberRange<? extends Number> intersect = NumberRange.castOrCopy(this.castTo(type).intersect(this.convertAndCast(range, type)));
        type = Numbers.narrowestClass(this.elementType, range.elementType);
        type = Numbers.widestClass(type, Numbers.narrowestClass((Number)((Object)intersect.minValue)));
        type = Numbers.widestClass(type, Numbers.narrowestClass((Number)((Object)intersect.maxValue)));
        return intersect.castTo(type);
    }

    public NumberRange<?> unionAny(NumberRange<?> range) throws IllegalArgumentException {
        Class<? extends Number> type = Numbers.widestClass(this.elementType, range.elementType);
        return NumberRange.castOrCopy(this.castTo(type).union(this.convertAndCast(range, type)));
    }

    public NumberRange<?>[] subtractAny(NumberRange<?> range) throws IllegalArgumentException {
        Class<? extends Number> type = Numbers.widestClass(this.elementType, range.elementType);
        return (NumberRange[])this.castTo(type).subtract(this.convertAndCast(range, type));
    }

    public NumberRange<?> transform(MathTransform1D converter) throws TransformException {
        double lower = this.getMinDouble();
        double upper = this.getMaxDouble();
        double min = converter.transform(lower);
        double max = converter.transform(upper);
        if (Double.doubleToLongBits(min) != Double.doubleToLongBits(lower) || Double.doubleToLongBits(max) != Double.doubleToLongBits(upper)) {
            if (min > max) {
                return NumberRange.create(max, this.isMaxIncluded, min, this.isMinIncluded);
            }
            return NumberRange.create(min, this.isMinIncluded, max, this.isMaxIncluded);
        }
        return this;
    }
}

