/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.client;

import com.fasterxml.jackson.databind.JavaType;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessor;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessorManager;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.exception.Exceptions;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.apache.servicecomb.transport.rest.client.RestClientTransportContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RestClientDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestClientDecoder.class);

    public Response decode(Invocation invocation, Response response) {
        if (response.getResult() instanceof Buffer) {
            Object result = this.extractBody(invocation, response);
            response.entity(result);
            if (response.isFailed()) {
                throw Exceptions.create((Response.StatusType)response.getStatus(), (Object)response.getResult());
            }
        }
        return response;
    }

    protected Object extractBody(Invocation invocation, Response response) {
        ProduceProcessor produceProcessor = this.safeFindProduceProcessor(invocation, response);
        JavaType responseType = invocation.findResponseType(response.getStatusCode());
        try {
            return produceProcessor.decodeResponse((Buffer)response.getResult(), responseType);
        }
        catch (Exception e) {
            throw this.createDecodeException(invocation, response, e);
        }
    }

    private ProduceProcessor safeFindProduceProcessor(Invocation invocation, Response response) {
        RestClientTransportContext transportContext = (RestClientTransportContext)invocation.getTransportContext();
        String contentType = this.extractContentType(response);
        ProduceProcessor produceProcessor = transportContext.getRestOperationMeta().findProduceProcessor(contentType);
        if (produceProcessor != null) {
            return produceProcessor;
        }
        HttpClientRequest httpClientRequest = transportContext.getHttpClientRequest();
        LOGGER.warn("operation={}, method={}, endpoint={}, uri={}, statusCode={}, reasonPhrase={}, response content-type={} is not supported in operation.", new Object[]{invocation.getMicroserviceQualifiedName(), httpClientRequest.getMethod(), invocation.getEndpoint().getEndpoint(), httpClientRequest.getURI(), response.getStatusCode(), response.getReasonPhrase(), response.getHeader("Content-Type")});
        return ProduceProcessorManager.INSTANCE.findDefaultProcessor();
    }

    protected String extractContentType(Response response) {
        String contentType = response.getHeader("Content-Type");
        if (contentType == null) {
            return null;
        }
        int idx = contentType.indexOf(";");
        return idx == -1 ? contentType : contentType.substring(0, idx);
    }

    protected InvocationException createDecodeException(Invocation invocation, Response response, Exception e) {
        RestClientTransportContext transportContext = (RestClientTransportContext)invocation.getTransportContext();
        HttpClientRequest httpClientRequest = transportContext.getHttpClientRequest();
        LOGGER.warn("failed to decode response body, operation={}, method={}, endpoint={}, uri={}, statusCode={}, reasonPhrase={}, content-type={}.", new Object[]{invocation.getMicroserviceQualifiedName(), httpClientRequest.getMethod(), invocation.getEndpoint().getEndpoint(), httpClientRequest.getURI(), response.getStatusCode(), response.getReasonPhrase(), response.getHeader("Content-Type")});
        if (response.isSucceed()) {
            return Exceptions.consumer((String)"scb_rest_client.40000002", (String)"failed to decode success response body.", (Throwable)e);
        }
        return Exceptions.consumer((String)"scb_rest_client.40000003", (String)"failed to decode fail response body.", (Throwable)e);
    }
}

