/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.accessLog.core.element.impl;

import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.common.accessLog.core.element.AccessLogItem;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.ServerAccessLogEvent;
import org.apache.servicecomb.swagger.invocation.Response;

public class ResponseHeaderAccessItem
implements AccessLogItem<RoutingContext> {
    public static final String RESULT_NOT_FOUND = "-";
    private final String varName;

    public ResponseHeaderAccessItem(String varName) {
        this.varName = varName;
    }

    @Override
    public void appendServerFormattedItem(ServerAccessLogEvent accessLogEvent, StringBuilder builder) {
        HttpServerResponse response = accessLogEvent.getRoutingContext().response();
        if (null == response || null == response.headers() || StringUtils.isEmpty((CharSequence)response.headers().get(this.varName))) {
            builder.append(RESULT_NOT_FOUND);
            return;
        }
        builder.append(response.headers().get(this.varName));
    }

    @Override
    public void appendClientFormattedItem(InvocationFinishEvent finishEvent, StringBuilder builder) {
        String value;
        Response response = finishEvent.getResponse();
        String string = value = response != null ? response.getHeader(this.varName) : null;
        if (null == value) {
            builder.append(RESULT_NOT_FOUND);
            return;
        }
        builder.append(value);
    }

    public String getVarName() {
        return this.varName;
    }
}

