/*
 * Decompiled with CFR 0.152.
 */
package opennlp.morfologik.cmdline.builder;

import java.io.File;
import java.nio.file.Path;
import morfologik.stemming.DictionaryMetadata;
import opennlp.morfologik.builder.MorfologikDictionaryBuilder;
import opennlp.morfologik.cmdline.builder.MorfologikDictionaryBuilderParams;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;

public class MorfologikDictionaryBuilderTool
extends BasicCmdLineTool {
    public String getShortDescription() {
        return "builds a binary POS Dictionary using Morfologik";
    }

    public String getHelp() {
        return this.getBasicHelp(Params.class);
    }

    public void run(String[] args) {
        Params params = (Params)this.validateAndParseParams(args, Params.class);
        File dictInFile = params.getInputFile();
        CmdLineUtil.checkInputFile((String)"dictionary input file", (File)dictInFile);
        Path metadataPath = DictionaryMetadata.getExpectedMetadataLocation((Path)dictInFile.toPath());
        CmdLineUtil.checkInputFile((String)"dictionary metadata (.info) input file", (File)metadataPath.toFile());
        MorfologikDictionaryBuilder builder = new MorfologikDictionaryBuilder();
        try {
            builder.build(dictInFile.toPath(), params.getOverwrite(), params.getValidate(), params.getAcceptBOM(), params.getAcceptCR(), params.getIgnoreEmpty());
        }
        catch (Exception e) {
            throw new TerminateToolException(-1, "Error while creating Morfologik POS Dictionary: " + e.getMessage(), (Throwable)e);
        }
    }

    static interface Params
    extends MorfologikDictionaryBuilderParams {
    }
}

