/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.observation.interceptors;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.observation.MetricConfig;
import org.apache.hc.client5.http.observation.ObservingOptions;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.util.Args;

public final class IoByteCounterExec
implements ExecChainHandler {
    private final MeterRegistry meterRegistry;
    private final ObservingOptions opts;
    private final MetricConfig mc;
    private final Counter.Builder reqBuilder;
    private final Counter.Builder respBuilder;

    public IoByteCounterExec(MeterRegistry meterRegistry, ObservingOptions opts, MetricConfig mc) {
        this.meterRegistry = (MeterRegistry)Args.notNull((Object)meterRegistry, (String)"meterRegistry");
        this.opts = (ObservingOptions)Args.notNull((Object)opts, (String)"observingOptions");
        this.mc = (MetricConfig)Args.notNull((Object)mc, (String)"metricConfig");
        this.reqBuilder = Counter.builder((String)(mc.prefix + ".request.bytes")).baseUnit("bytes").description("HTTP request payload size");
        this.respBuilder = Counter.builder((String)(mc.prefix + ".response.bytes")).baseUnit("bytes").description("HTTP response payload size");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        long respBytes;
        ClassicHttpResponse classicHttpResponse;
        if (!this.opts.spanSampling.test(request.getRequestUri())) {
            return chain.proceed(request, scope);
        }
        long reqBytes = IoByteCounterExec.contentLength(request.getEntity());
        ClassicHttpResponse response = null;
        try {
            classicHttpResponse = response = chain.proceed(request, scope);
            respBytes = IoByteCounterExec.contentLength(response != null ? response.getEntity() : null);
        }
        catch (Throwable throwable) {
            long respBytes2 = IoByteCounterExec.contentLength(response != null ? response.getEntity() : null);
            int status = response != null ? response.getCode() : 599;
            String protocol = scope.route.getTargetHost().getSchemeName();
            String target = scope.route.getTargetHost().getHostName();
            String uri = request.getRequestUri();
            List<Tag> tags = this.buildTags(request.getMethod(), status, protocol, target, uri);
            if (reqBytes >= 0L) {
                this.reqBuilder.tags(tags).tags(this.mc.commonTags).register(this.meterRegistry).increment((double)reqBytes);
            }
            if (respBytes2 >= 0L) {
                this.respBuilder.tags(tags).tags(this.mc.commonTags).register(this.meterRegistry).increment((double)respBytes2);
            }
            throw throwable;
        }
        int status = response != null ? response.getCode() : 599;
        String protocol = scope.route.getTargetHost().getSchemeName();
        String target = scope.route.getTargetHost().getHostName();
        String uri = request.getRequestUri();
        List<Tag> tags = this.buildTags(request.getMethod(), status, protocol, target, uri);
        if (reqBytes >= 0L) {
            this.reqBuilder.tags(tags).tags(this.mc.commonTags).register(this.meterRegistry).increment((double)reqBytes);
        }
        if (respBytes >= 0L) {
            this.respBuilder.tags(tags).tags(this.mc.commonTags).register(this.meterRegistry).increment((double)respBytes);
        }
        return classicHttpResponse;
    }

    private static long contentLength(HttpEntity entity) {
        if (entity == null) {
            return -1L;
        }
        long len = entity.getContentLength();
        return len >= 0L ? len : -1L;
    }

    private List<Tag> buildTags(String method, int status, String protocol, String target, String uri) {
        ArrayList<Tag> tags = new ArrayList<Tag>(8);
        tags.add(Tag.of((String)"method", (String)method));
        tags.add(Tag.of((String)"status", (String)Integer.toString(status)));
        if (this.opts.tagLevel == ObservingOptions.TagLevel.EXTENDED) {
            tags.add(Tag.of((String)"protocol", (String)protocol));
            tags.add(Tag.of((String)"target", (String)target));
        }
        if (this.mc.perUriIo) {
            tags.add(Tag.of((String)"uri", (String)uri));
        }
        return this.opts.tagCustomizer.apply(tags, method, status, protocol, target, uri);
    }
}

